
import Foundation
import RegexBuilder

let usLocale = Locale(identifier: "en_US")

let separator = /\n/
let content = """
06/15/2025 Lamp $35.00
06/21/2025 Desk $250.50
06/29/2025 Chair $129.00
"""
let regex = Regex {
   Capture {
      One(.date(.numeric, locale: usLocale, timeZone: .current))
   }
   OneOrMore(.whitespace)
   Capture {
      OneOrMore(CharacterClass("a"..."z", "A"..."Z"))
   }
   OneOrMore(.whitespace)
   Capture {
      One(.localizedCurrency(code: "USD", locale: usLocale))
   }
}
let lines = content.split(separator: separator)
for line in lines {
   if let result = line.firstMatch(of: regex) {
      print("Date: \(result.output.1.formatted(date: .complete, time: .omitted))")
      print("Item: \(result.output.2)")
      print("Price: \(result.output.3)")
   }
}
